// @license magnet:?xt=urn:btih:0b31508aeb0634b347b8270c7bee4d411b5d4109&dn=agpl-3.0.txt AGPL-v3-or-Later

var PosixBracketExpressions = {
  // source: https://github.com/ruby/ruby/blob/ruby_2_4/enc/unicode/9.0.0/name2ctype.h#L3544
  word: "\\u0030-\\u0039" +
        "\\u0041-\\u005a" +
        "\\u005f-\\u005f" +
        "\\u0061-\\u007a" +
        "\\u00aa-\\u00aa" +
        "\\u00b5-\\u00b5" +
        "\\u00ba-\\u00ba" +
        "\\u00c0-\\u00d6" +
        "\\u00d8-\\u00f6" +
        "\\u00f8-\\u02c1" +
        "\\u02c6-\\u02d1" +
        "\\u02e0-\\u02e4" +
        "\\u02ec-\\u02ec" +
        "\\u02ee-\\u02ee" +
        "\\u0300-\\u0374" +
        "\\u0376-\\u0377" +
        "\\u037a-\\u037d" +
        "\\u037f-\\u037f" +
        "\\u0386-\\u0386" +
        "\\u0388-\\u038a" +
        "\\u038c-\\u038c" +
        "\\u038e-\\u03a1" +
        "\\u03a3-\\u03f5" +
        "\\u03f7-\\u0481" +
        "\\u0483-\\u052f" +
        "\\u0531-\\u0556" +
        "\\u0559-\\u0559" +
        "\\u0561-\\u0587" +
        "\\u0591-\\u05bd" +
        "\\u05bf-\\u05bf" +
        "\\u05c1-\\u05c2" +
        "\\u05c4-\\u05c5" +
        "\\u05c7-\\u05c7" +
        "\\u05d0-\\u05ea" +
        "\\u05f0-\\u05f2" +
        "\\u0610-\\u061a" +
        "\\u0620-\\u0669" +
        "\\u066e-\\u06d3" +
        "\\u06d5-\\u06dc" +
        "\\u06df-\\u06e8" +
        "\\u06ea-\\u06fc" +
        "\\u06ff-\\u06ff" +
        "\\u0710-\\u074a" +
        "\\u074d-\\u07b1" +
        "\\u07c0-\\u07f5" +
        "\\u07fa-\\u07fa" +
        "\\u0800-\\u082d" +
        "\\u0840-\\u085b" +
        "\\u08a0-\\u08b4" +
        "\\u08b6-\\u08bd" +
        "\\u08d4-\\u08e1" +
        "\\u08e3-\\u0963" +
        "\\u0966-\\u096f" +
        "\\u0971-\\u0983" +
        "\\u0985-\\u098c" +
        "\\u098f-\\u0990" +
        "\\u0993-\\u09a8" +
        "\\u09aa-\\u09b0" +
        "\\u09b2-\\u09b2" +
        "\\u09b6-\\u09b9" +
        "\\u09bc-\\u09c4" +
        "\\u09c7-\\u09c8" +
        "\\u09cb-\\u09ce" +
        "\\u09d7-\\u09d7" +
        "\\u09dc-\\u09dd" +
        "\\u09df-\\u09e3" +
        "\\u09e6-\\u09f1" +
        "\\u0a01-\\u0a03" +
        "\\u0a05-\\u0a0a" +
        "\\u0a0f-\\u0a10" +
        "\\u0a13-\\u0a28" +
        "\\u0a2a-\\u0a30" +
        "\\u0a32-\\u0a33" +
        "\\u0a35-\\u0a36" +
        "\\u0a38-\\u0a39" +
        "\\u0a3c-\\u0a3c" +
        "\\u0a3e-\\u0a42" +
        "\\u0a47-\\u0a48" +
        "\\u0a4b-\\u0a4d" +
        "\\u0a51-\\u0a51" +
        "\\u0a59-\\u0a5c" +
        "\\u0a5e-\\u0a5e" +
        "\\u0a66-\\u0a75" +
        "\\u0a81-\\u0a83" +
        "\\u0a85-\\u0a8d" +
        "\\u0a8f-\\u0a91" +
        "\\u0a93-\\u0aa8" +
        "\\u0aaa-\\u0ab0" +
        "\\u0ab2-\\u0ab3" +
        "\\u0ab5-\\u0ab9" +
        "\\u0abc-\\u0ac5" +
        "\\u0ac7-\\u0ac9" +
        "\\u0acb-\\u0acd" +
        "\\u0ad0-\\u0ad0" +
        "\\u0ae0-\\u0ae3" +
        "\\u0ae6-\\u0aef" +
        "\\u0af9-\\u0af9" +
        "\\u0b01-\\u0b03" +
        "\\u0b05-\\u0b0c" +
        "\\u0b0f-\\u0b10" +
        "\\u0b13-\\u0b28" +
        "\\u0b2a-\\u0b30" +
        "\\u0b32-\\u0b33" +
        "\\u0b35-\\u0b39" +
        "\\u0b3c-\\u0b44" +
        "\\u0b47-\\u0b48" +
        "\\u0b4b-\\u0b4d" +
        "\\u0b56-\\u0b57" +
        "\\u0b5c-\\u0b5d" +
        "\\u0b5f-\\u0b63" +
        "\\u0b66-\\u0b6f" +
        "\\u0b71-\\u0b71" +
        "\\u0b82-\\u0b83" +
        "\\u0b85-\\u0b8a" +
        "\\u0b8e-\\u0b90" +
        "\\u0b92-\\u0b95" +
        "\\u0b99-\\u0b9a" +
        "\\u0b9c-\\u0b9c" +
        "\\u0b9e-\\u0b9f" +
        "\\u0ba3-\\u0ba4" +
        "\\u0ba8-\\u0baa" +
        "\\u0bae-\\u0bb9" +
        "\\u0bbe-\\u0bc2" +
        "\\u0bc6-\\u0bc8" +
        "\\u0bca-\\u0bcd" +
        "\\u0bd0-\\u0bd0" +
        "\\u0bd7-\\u0bd7" +
        "\\u0be6-\\u0bef" +
        "\\u0c00-\\u0c03" +
        "\\u0c05-\\u0c0c" +
        "\\u0c0e-\\u0c10" +
        "\\u0c12-\\u0c28" +
        "\\u0c2a-\\u0c39" +
        "\\u0c3d-\\u0c44" +
        "\\u0c46-\\u0c48" +
        "\\u0c4a-\\u0c4d" +
        "\\u0c55-\\u0c56" +
        "\\u0c58-\\u0c5a" +
        "\\u0c60-\\u0c63" +
        "\\u0c66-\\u0c6f" +
        "\\u0c80-\\u0c83" +
        "\\u0c85-\\u0c8c" +
        "\\u0c8e-\\u0c90" +
        "\\u0c92-\\u0ca8" +
        "\\u0caa-\\u0cb3" +
        "\\u0cb5-\\u0cb9" +
        "\\u0cbc-\\u0cc4" +
        "\\u0cc6-\\u0cc8" +
        "\\u0cca-\\u0ccd" +
        "\\u0cd5-\\u0cd6" +
        "\\u0cde-\\u0cde" +
        "\\u0ce0-\\u0ce3" +
        "\\u0ce6-\\u0cef" +
        "\\u0cf1-\\u0cf2" +
        "\\u0d01-\\u0d03" +
        "\\u0d05-\\u0d0c" +
        "\\u0d0e-\\u0d10" +
        "\\u0d12-\\u0d3a" +
        "\\u0d3d-\\u0d44" +
        "\\u0d46-\\u0d48" +
        "\\u0d4a-\\u0d4e" +
        "\\u0d54-\\u0d57" +
        "\\u0d5f-\\u0d63" +
        "\\u0d66-\\u0d6f" +
        "\\u0d7a-\\u0d7f" +
        "\\u0d82-\\u0d83" +
        "\\u0d85-\\u0d96" +
        "\\u0d9a-\\u0db1" +
        "\\u0db3-\\u0dbb" +
        "\\u0dbd-\\u0dbd" +
        "\\u0dc0-\\u0dc6" +
        "\\u0dca-\\u0dca" +
        "\\u0dcf-\\u0dd4" +
        "\\u0dd6-\\u0dd6" +
        "\\u0dd8-\\u0ddf" +
        "\\u0de6-\\u0def" +
        "\\u0df2-\\u0df3" +
        "\\u0e01-\\u0e3a" +
        "\\u0e40-\\u0e4e" +
        "\\u0e50-\\u0e59" +
        "\\u0e81-\\u0e82" +
        "\\u0e84-\\u0e84" +
        "\\u0e87-\\u0e88" +
        "\\u0e8a-\\u0e8a" +
        "\\u0e8d-\\u0e8d" +
        "\\u0e94-\\u0e97" +
        "\\u0e99-\\u0e9f" +
        "\\u0ea1-\\u0ea3" +
        "\\u0ea5-\\u0ea5" +
        "\\u0ea7-\\u0ea7" +
        "\\u0eaa-\\u0eab" +
        "\\u0ead-\\u0eb9" +
        "\\u0ebb-\\u0ebd" +
        "\\u0ec0-\\u0ec4" +
        "\\u0ec6-\\u0ec6" +
        "\\u0ec8-\\u0ecd" +
        "\\u0ed0-\\u0ed9" +
        "\\u0edc-\\u0edf" +
        "\\u0f00-\\u0f00" +
        "\\u0f18-\\u0f19" +
        "\\u0f20-\\u0f29" +
        "\\u0f35-\\u0f35" +
        "\\u0f37-\\u0f37" +
        "\\u0f39-\\u0f39" +
        "\\u0f3e-\\u0f47" +
        "\\u0f49-\\u0f6c" +
        "\\u0f71-\\u0f84" +
        "\\u0f86-\\u0f97" +
        "\\u0f99-\\u0fbc" +
        "\\u0fc6-\\u0fc6" +
        "\\u1000-\\u1049" +
        "\\u1050-\\u109d" +
        "\\u10a0-\\u10c5" +
        "\\u10c7-\\u10c7" +
        "\\u10cd-\\u10cd" +
        "\\u10d0-\\u10fa" +
        "\\u10fc-\\u1248" +
        "\\u124a-\\u124d" +
        "\\u1250-\\u1256" +
        "\\u1258-\\u1258" +
        "\\u125a-\\u125d" +
        "\\u1260-\\u1288" +
        "\\u128a-\\u128d" +
        "\\u1290-\\u12b0" +
        "\\u12b2-\\u12b5" +
        "\\u12b8-\\u12be" +
        "\\u12c0-\\u12c0" +
        "\\u12c2-\\u12c5" +
        "\\u12c8-\\u12d6" +
        "\\u12d8-\\u1310" +
        "\\u1312-\\u1315" +
        "\\u1318-\\u135a" +
        "\\u135d-\\u135f" +
        "\\u1380-\\u138f" +
        "\\u13a0-\\u13f5" +
        "\\u13f8-\\u13fd" +
        "\\u1401-\\u166c" +
        "\\u166f-\\u167f" +
        "\\u1681-\\u169a" +
        "\\u16a0-\\u16ea" +
        "\\u16ee-\\u16f8" +
        "\\u1700-\\u170c" +
        "\\u170e-\\u1714" +
        "\\u1720-\\u1734" +
        "\\u1740-\\u1753" +
        "\\u1760-\\u176c" +
        "\\u176e-\\u1770" +
        "\\u1772-\\u1773" +
        "\\u1780-\\u17d3" +
        "\\u17d7-\\u17d7" +
        "\\u17dc-\\u17dd" +
        "\\u17e0-\\u17e9" +
        "\\u180b-\\u180d" +
        "\\u1810-\\u1819" +
        "\\u1820-\\u1877" +
        "\\u1880-\\u18aa" +
        "\\u18b0-\\u18f5" +
        "\\u1900-\\u191e" +
        "\\u1920-\\u192b" +
        "\\u1930-\\u193b" +
        "\\u1946-\\u196d" +
        "\\u1970-\\u1974" +
        "\\u1980-\\u19ab" +
        "\\u19b0-\\u19c9" +
        "\\u19d0-\\u19d9" +
        "\\u1a00-\\u1a1b" +
        "\\u1a20-\\u1a5e" +
        "\\u1a60-\\u1a7c" +
        "\\u1a7f-\\u1a89" +
        "\\u1a90-\\u1a99" +
        "\\u1aa7-\\u1aa7" +
        "\\u1ab0-\\u1abe" +
        "\\u1b00-\\u1b4b" +
        "\\u1b50-\\u1b59" +
        "\\u1b6b-\\u1b73" +
        "\\u1b80-\\u1bf3" +
        "\\u1c00-\\u1c37" +
        "\\u1c40-\\u1c49" +
        "\\u1c4d-\\u1c7d" +
        "\\u1c80-\\u1c88" +
        "\\u1cd0-\\u1cd2" +
        "\\u1cd4-\\u1cf6" +
        "\\u1cf8-\\u1cf9" +
        "\\u1d00-\\u1df5" +
        "\\u1dfb-\\u1f15" +
        "\\u1f18-\\u1f1d" +
        "\\u1f20-\\u1f45" +
        "\\u1f48-\\u1f4d" +
        "\\u1f50-\\u1f57" +
        "\\u1f59-\\u1f59" +
        "\\u1f5b-\\u1f5b" +
        "\\u1f5d-\\u1f5d" +
        "\\u1f5f-\\u1f7d" +
        "\\u1f80-\\u1fb4" +
        "\\u1fb6-\\u1fbc" +
        "\\u1fbe-\\u1fbe" +
        "\\u1fc2-\\u1fc4" +
        "\\u1fc6-\\u1fcc" +
        "\\u1fd0-\\u1fd3" +
        "\\u1fd6-\\u1fdb" +
        "\\u1fe0-\\u1fec" +
        "\\u1ff2-\\u1ff4" +
        "\\u1ff6-\\u1ffc" +
        "\\u203f-\\u2040" +
        "\\u2054-\\u2054" +
        "\\u2071-\\u2071" +
        "\\u207f-\\u207f" +
        "\\u2090-\\u209c" +
        "\\u20d0-\\u20f0" +
        "\\u2102-\\u2102" +
        "\\u2107-\\u2107" +
        "\\u210a-\\u2113" +
        "\\u2115-\\u2115" +
        "\\u2119-\\u211d" +
        "\\u2124-\\u2124" +
        "\\u2126-\\u2126" +
        "\\u2128-\\u2128" +
        "\\u212a-\\u212d" +
        "\\u212f-\\u2139" +
        "\\u213c-\\u213f" +
        "\\u2145-\\u2149" +
        "\\u214e-\\u214e" +
        "\\u2160-\\u2188" +
        "\\u24b6-\\u24e9" +
        "\\u2c00-\\u2c2e" +
        "\\u2c30-\\u2c5e" +
        "\\u2c60-\\u2ce4" +
        "\\u2ceb-\\u2cf3" +
        "\\u2d00-\\u2d25" +
        "\\u2d27-\\u2d27" +
        "\\u2d2d-\\u2d2d" +
        "\\u2d30-\\u2d67" +
        "\\u2d6f-\\u2d6f" +
        "\\u2d7f-\\u2d96" +
        "\\u2da0-\\u2da6" +
        "\\u2da8-\\u2dae" +
        "\\u2db0-\\u2db6" +
        "\\u2db8-\\u2dbe" +
        "\\u2dc0-\\u2dc6" +
        "\\u2dc8-\\u2dce" +
        "\\u2dd0-\\u2dd6" +
        "\\u2dd8-\\u2dde" +
        "\\u2de0-\\u2dff" +
        "\\u2e2f-\\u2e2f" +
        "\\u3005-\\u3007" +
        "\\u3021-\\u302f" +
        "\\u3031-\\u3035" +
        "\\u3038-\\u303c" +
        "\\u3041-\\u3096" +
        "\\u3099-\\u309a" +
        "\\u309d-\\u309f" +
        "\\u30a1-\\u30fa" +
        "\\u30fc-\\u30ff" +
        "\\u3105-\\u312d" +
        "\\u3131-\\u318e" +
        "\\u31a0-\\u31ba" +
        "\\u31f0-\\u31ff" +
        "\\u3400-\\u4db5" +
        "\\u4e00-\\u9fd5" +
        "\\ua000-\\ua48c" +
        "\\ua4d0-\\ua4fd" +
        "\\ua500-\\ua60c" +
        "\\ua610-\\ua62b" +
        "\\ua640-\\ua672" +
        "\\ua674-\\ua67d" +
        "\\ua67f-\\ua6f1" +
        "\\ua717-\\ua71f" +
        "\\ua722-\\ua788" +
        "\\ua78b-\\ua7ae" +
        "\\ua7b0-\\ua7b7" +
        "\\ua7f7-\\ua827" +
        "\\ua840-\\ua873" +
        "\\ua880-\\ua8c5" +
        "\\ua8d0-\\ua8d9" +
        "\\ua8e0-\\ua8f7" +
        "\\ua8fb-\\ua8fb" +
        "\\ua8fd-\\ua8fd" +
        "\\ua900-\\ua92d" +
        "\\ua930-\\ua953" +
        "\\ua960-\\ua97c" +
        "\\ua980-\\ua9c0" +
        "\\ua9cf-\\ua9d9" +
        "\\ua9e0-\\ua9fe" +
        "\\uaa00-\\uaa36" +
        "\\uaa40-\\uaa4d" +
        "\\uaa50-\\uaa59" +
        "\\uaa60-\\uaa76" +
        "\\uaa7a-\\uaac2" +
        "\\uaadb-\\uaadd" +
        "\\uaae0-\\uaaef" +
        "\\uaaf2-\\uaaf6" +
        "\\uab01-\\uab06" +
        "\\uab09-\\uab0e" +
        "\\uab11-\\uab16" +
        "\\uab20-\\uab26" +
        "\\uab28-\\uab2e" +
        "\\uab30-\\uab5a" +
        "\\uab5c-\\uab65" +
        "\\uab70-\\uabea" +
        "\\uabec-\\uabed" +
        "\\uabf0-\\uabf9" +
        "\\uac00-\\ud7a3" +
        "\\ud7b0-\\ud7c6" +
        "\\ud7cb-\\ud7fb" +
        "\\uf900-\\ufa6d" +
        "\\ufa70-\\ufad9" +
        "\\ufb00-\\ufb06" +
        "\\ufb13-\\ufb17" +
        "\\ufb1d-\\ufb28" +
        "\\ufb2a-\\ufb36" +
        "\\ufb38-\\ufb3c" +
        "\\ufb3e-\\ufb3e" +
        "\\ufb40-\\ufb41" +
        "\\ufb43-\\ufb44" +
        "\\ufb46-\\ufbb1" +
        "\\ufbd3-\\ufd3d" +
        "\\ufd50-\\ufd8f" +
        "\\ufd92-\\ufdc7" +
        "\\ufdf0-\\ufdfb" +
        "\\ufe00-\\ufe0f" +
        "\\ufe20-\\ufe2f" +
        "\\ufe33-\\ufe34" +
        "\\ufe4d-\\ufe4f" +
        "\\ufe70-\\ufe74" +
        "\\ufe76-\\ufefc" +
        "\\uff10-\\uff19" +
        "\\uff21-\\uff3a" +
        "\\uff3f-\\uff3f" +
        "\\uff41-\\uff5a" +
        "\\uff66-\\uffbe" +
        "\\uffc2-\\uffc7" +
        "\\uffca-\\uffcf" +
        "\\uffd2-\\uffd7" +
        "\\uffda-\\uffdc",
        // "\\u10000-\\u1000b" +
        // "\\u1000d-\\u10026" +
        // "\\u10028-\\u1003a" +
        // "\\u1003c-\\u1003d" +
        // "\\u1003f-\\u1004d" +
        // "\\u10050-\\u1005d" +
        // "\\u10080-\\u100fa" +
        // "\\u10140-\\u10174" +
        // "\\u101fd-\\u101fd" +
        // "\\u10280-\\u1029c" +
        // "\\u102a0-\\u102d0" +
        // "\\u102e0-\\u102e0" +
        // "\\u10300-\\u1031f" +
        // "\\u10330-\\u1034a" +
        // "\\u10350-\\u1037a" +
        // "\\u10380-\\u1039d" +
        // "\\u103a0-\\u103c3" +
        // "\\u103c8-\\u103cf" +
        // "\\u103d1-\\u103d5" +
        // "\\u10400-\\u1049d" +
        // "\\u104a0-\\u104a9" +
        // "\\u104b0-\\u104d3" +
        // "\\u104d8-\\u104fb" +
        // "\\u10500-\\u10527" +
        // "\\u10530-\\u10563" +
        // "\\u10600-\\u10736" +
        // "\\u10740-\\u10755" +
        // "\\u10760-\\u10767" +
        // "\\u10800-\\u10805" +
        // "\\u10808-\\u10808" +
        // "\\u1080a-\\u10835" +
        // "\\u10837-\\u10838" +
        // "\\u1083c-\\u1083c" +
        // "\\u1083f-\\u10855" +
        // "\\u10860-\\u10876" +
        // "\\u10880-\\u1089e" +
        // "\\u108e0-\\u108f2" +
        // "\\u108f4-\\u108f5" +
        // "\\u10900-\\u10915" +
        // "\\u10920-\\u10939" +
        // "\\u10980-\\u109b7" +
        // "\\u109be-\\u109bf" +
        // "\\u10a00-\\u10a03" +
        // "\\u10a05-\\u10a06" +
        // "\\u10a0c-\\u10a13" +
        // "\\u10a15-\\u10a17" +
        // "\\u10a19-\\u10a33" +
        // "\\u10a38-\\u10a3a" +
        // "\\u10a3f-\\u10a3f" +
        // "\\u10a60-\\u10a7c" +
        // "\\u10a80-\\u10a9c" +
        // "\\u10ac0-\\u10ac7" +
        // "\\u10ac9-\\u10ae6" +
        // "\\u10b00-\\u10b35" +
        // "\\u10b40-\\u10b55" +
        // "\\u10b60-\\u10b72" +
        // "\\u10b80-\\u10b91" +
        // "\\u10c00-\\u10c48" +
        // "\\u10c80-\\u10cb2" +
        // "\\u10cc0-\\u10cf2" +
        // "\\u11000-\\u11046" +
        // "\\u11066-\\u1106f" +
        // "\\u1107f-\\u110ba" +
        // "\\u110d0-\\u110e8" +
        // "\\u110f0-\\u110f9" +
        // "\\u11100-\\u11134" +
        // "\\u11136-\\u1113f" +
        // "\\u11150-\\u11173" +
        // "\\u11176-\\u11176" +
        // "\\u11180-\\u111c4" +
        // "\\u111ca-\\u111cc" +
        // "\\u111d0-\\u111da" +
        // "\\u111dc-\\u111dc" +
        // "\\u11200-\\u11211" +
        // "\\u11213-\\u11237" +
        // "\\u1123e-\\u1123e" +
        // "\\u11280-\\u11286" +
        // "\\u11288-\\u11288" +
        // "\\u1128a-\\u1128d" +
        // "\\u1128f-\\u1129d" +
        // "\\u1129f-\\u112a8" +
        // "\\u112b0-\\u112ea" +
        // "\\u112f0-\\u112f9" +
        // "\\u11300-\\u11303" +
        // "\\u11305-\\u1130c" +
        // "\\u1130f-\\u11310" +
        // "\\u11313-\\u11328" +
        // "\\u1132a-\\u11330" +
        // "\\u11332-\\u11333" +
        // "\\u11335-\\u11339" +
        // "\\u1133c-\\u11344" +
        // "\\u11347-\\u11348" +
        // "\\u1134b-\\u1134d" +
        // "\\u11350-\\u11350" +
        // "\\u11357-\\u11357" +
        // "\\u1135d-\\u11363" +
        // "\\u11366-\\u1136c" +
        // "\\u11370-\\u11374" +
        // "\\u11400-\\u1144a" +
        // "\\u11450-\\u11459" +
        // "\\u11480-\\u114c5" +
        // "\\u114c7-\\u114c7" +
        // "\\u114d0-\\u114d9" +
        // "\\u11580-\\u115b5" +
        // "\\u115b8-\\u115c0" +
        // "\\u115d8-\\u115dd" +
        // "\\u11600-\\u11640" +
        // "\\u11644-\\u11644" +
        // "\\u11650-\\u11659" +
        // "\\u11680-\\u116b7" +
        // "\\u116c0-\\u116c9" +
        // "\\u11700-\\u11719" +
        // "\\u1171d-\\u1172b" +
        // "\\u11730-\\u11739" +
        // "\\u118a0-\\u118e9" +
        // "\\u118ff-\\u118ff" +
        // "\\u11ac0-\\u11af8" +
        // "\\u11c00-\\u11c08" +
        // "\\u11c0a-\\u11c36" +
        // "\\u11c38-\\u11c40" +
        // "\\u11c50-\\u11c59" +
        // "\\u11c72-\\u11c8f" +
        // "\\u11c92-\\u11ca7" +
        // "\\u11ca9-\\u11cb6" +
        // "\\u12000-\\u12399" +
        // "\\u12400-\\u1246e" +
        // "\\u12480-\\u12543" +
        // "\\u13000-\\u1342e" +
        // "\\u14400-\\u14646" +
        // "\\u16800-\\u16a38" +
        // "\\u16a40-\\u16a5e" +
        // "\\u16a60-\\u16a69" +
        // "\\u16ad0-\\u16aed" +
        // "\\u16af0-\\u16af4" +
        // "\\u16b00-\\u16b36" +
        // "\\u16b40-\\u16b43" +
        // "\\u16b50-\\u16b59" +
        // "\\u16b63-\\u16b77" +
        // "\\u16b7d-\\u16b8f" +
        // "\\u16f00-\\u16f44" +
        // "\\u16f50-\\u16f7e" +
        // "\\u16f8f-\\u16f9f" +
        // "\\u16fe0-\\u16fe0" +
        // "\\u17000-\\u187ec" +
        // "\\u18800-\\u18af2" +
        // "\\u1b000-\\u1b001" +
        // "\\u1bc00-\\u1bc6a" +
        // "\\u1bc70-\\u1bc7c" +
        // "\\u1bc80-\\u1bc88" +
        // "\\u1bc90-\\u1bc99" +
        // "\\u1bc9d-\\u1bc9e" +
        // "\\u1d165-\\u1d169" +
        // "\\u1d16d-\\u1d172" +
        // "\\u1d17b-\\u1d182" +
        // "\\u1d185-\\u1d18b" +
        // "\\u1d1aa-\\u1d1ad" +
        // "\\u1d242-\\u1d244" +
        // "\\u1d400-\\u1d454" +
        // "\\u1d456-\\u1d49c" +
        // "\\u1d49e-\\u1d49f" +
        // "\\u1d4a2-\\u1d4a2" +
        // "\\u1d4a5-\\u1d4a6" +
        // "\\u1d4a9-\\u1d4ac" +
        // "\\u1d4ae-\\u1d4b9" +
        // "\\u1d4bb-\\u1d4bb" +
        // "\\u1d4bd-\\u1d4c3" +
        // "\\u1d4c5-\\u1d505" +
        // "\\u1d507-\\u1d50a" +
        // "\\u1d50d-\\u1d514" +
        // "\\u1d516-\\u1d51c" +
        // "\\u1d51e-\\u1d539" +
        // "\\u1d53b-\\u1d53e" +
        // "\\u1d540-\\u1d544" +
        // "\\u1d546-\\u1d546" +
        // "\\u1d54a-\\u1d550" +
        // "\\u1d552-\\u1d6a5" +
        // "\\u1d6a8-\\u1d6c0" +
        // "\\u1d6c2-\\u1d6da" +
        // "\\u1d6dc-\\u1d6fa" +
        // "\\u1d6fc-\\u1d714" +
        // "\\u1d716-\\u1d734" +
        // "\\u1d736-\\u1d74e" +
        // "\\u1d750-\\u1d76e" +
        // "\\u1d770-\\u1d788" +
        // "\\u1d78a-\\u1d7a8" +
        // "\\u1d7aa-\\u1d7c2" +
        // "\\u1d7c4-\\u1d7cb" +
        // "\\u1d7ce-\\u1d7ff" +
        // "\\u1da00-\\u1da36" +
        // "\\u1da3b-\\u1da6c" +
        // "\\u1da75-\\u1da75" +
        // "\\u1da84-\\u1da84" +
        // "\\u1da9b-\\u1da9f" +
        // "\\u1daa1-\\u1daaf" +
        // "\\u1e000-\\u1e006" +
        // "\\u1e008-\\u1e018" +
        // "\\u1e01b-\\u1e021" +
        // "\\u1e023-\\u1e024" +
        // "\\u1e026-\\u1e02a" +
        // "\\u1e800-\\u1e8c4" +
        // "\\u1e8d0-\\u1e8d6" +
        // "\\u1e900-\\u1e94a" +
        // "\\u1e950-\\u1e959" +
        // "\\u1ee00-\\u1ee03" +
        // "\\u1ee05-\\u1ee1f" +
        // "\\u1ee21-\\u1ee22" +
        // "\\u1ee24-\\u1ee24" +
        // "\\u1ee27-\\u1ee27" +
        // "\\u1ee29-\\u1ee32" +
        // "\\u1ee34-\\u1ee37" +
        // "\\u1ee39-\\u1ee39" +
        // "\\u1ee3b-\\u1ee3b" +
        // "\\u1ee42-\\u1ee42" +
        // "\\u1ee47-\\u1ee47" +
        // "\\u1ee49-\\u1ee49" +
        // "\\u1ee4b-\\u1ee4b" +
        // "\\u1ee4d-\\u1ee4f" +
        // "\\u1ee51-\\u1ee52" +
        // "\\u1ee54-\\u1ee54" +
        // "\\u1ee57-\\u1ee57" +
        // "\\u1ee59-\\u1ee59" +
        // "\\u1ee5b-\\u1ee5b" +
        // "\\u1ee5d-\\u1ee5d" +
        // "\\u1ee5f-\\u1ee5f" +
        // "\\u1ee61-\\u1ee62" +
        // "\\u1ee64-\\u1ee64" +
        // "\\u1ee67-\\u1ee6a" +
        // "\\u1ee6c-\\u1ee72" +
        // "\\u1ee74-\\u1ee77" +
        // "\\u1ee79-\\u1ee7c" +
        // "\\u1ee7e-\\u1ee7e" +
        // "\\u1ee80-\\u1ee89" +
        // "\\u1ee8b-\\u1ee9b" +
        // "\\u1eea1-\\u1eea3" +
        // "\\u1eea5-\\u1eea9" +
        // "\\u1eeab-\\u1eebb" +
        // "\\u1f130-\\u1f149" +
        // "\\u1f150-\\u1f169" +
        // "\\u1f170-\\u1f189" +
        // "\\u20000-\\u2a6d6" +
        // "\\u2a700-\\u2b734" +
        // "\\u2b740-\\u2b81d" +
        // "\\u2b820-\\u2cea1" +
        // "\\u2f800-\\u2fa1d" +
        // "\\ue0100-\\ue01ef",

  // source: https://github.com/ruby/ruby/blob/ruby_2_4/enc/unicode/9.0.0/name2ctype.h#L4227
  alnum: "\\u0030-\\u0039" +
         "\\u0041-\\u005a" +
         "\\u0061-\\u007a" +
         "\\u00aa-\\u00aa" +
         "\\u00b5-\\u00b5" +
         "\\u00ba-\\u00ba" +
         "\\u00c0-\\u00d6" +
         "\\u00d8-\\u00f6" +
         "\\u00f8-\\u02c1" +
         "\\u02c6-\\u02d1" +
         "\\u02e0-\\u02e4" +
         "\\u02ec-\\u02ec" +
         "\\u02ee-\\u02ee" +
         "\\u0345-\\u0345" +
         "\\u0370-\\u0374" +
         "\\u0376-\\u0377" +
         "\\u037a-\\u037d" +
         "\\u037f-\\u037f" +
         "\\u0386-\\u0386" +
         "\\u0388-\\u038a" +
         "\\u038c-\\u038c" +
         "\\u038e-\\u03a1" +
         "\\u03a3-\\u03f5" +
         "\\u03f7-\\u0481" +
         "\\u048a-\\u052f" +
         "\\u0531-\\u0556" +
         "\\u0559-\\u0559" +
         "\\u0561-\\u0587" +
         "\\u05b0-\\u05bd" +
         "\\u05bf-\\u05bf" +
         "\\u05c1-\\u05c2" +
         "\\u05c4-\\u05c5" +
         "\\u05c7-\\u05c7" +
         "\\u05d0-\\u05ea" +
         "\\u05f0-\\u05f2" +
         "\\u0610-\\u061a" +
         "\\u0620-\\u0657" +
         "\\u0659-\\u0669" +
         "\\u066e-\\u06d3" +
         "\\u06d5-\\u06dc" +
         "\\u06e1-\\u06e8" +
         "\\u06ed-\\u06fc" +
         "\\u06ff-\\u06ff" +
         "\\u0710-\\u073f" +
         "\\u074d-\\u07b1" +
         "\\u07c0-\\u07ea" +
         "\\u07f4-\\u07f5" +
         "\\u07fa-\\u07fa" +
         "\\u0800-\\u0817" +
         "\\u081a-\\u082c" +
         "\\u0840-\\u0858" +
         "\\u08a0-\\u08b4" +
         "\\u08b6-\\u08bd" +
         "\\u08d4-\\u08df" +
         "\\u08e3-\\u08e9" +
         "\\u08f0-\\u093b" +
         "\\u093d-\\u094c" +
         "\\u094e-\\u0950" +
         "\\u0955-\\u0963" +
         "\\u0966-\\u096f" +
         "\\u0971-\\u0983" +
         "\\u0985-\\u098c" +
         "\\u098f-\\u0990" +
         "\\u0993-\\u09a8" +
         "\\u09aa-\\u09b0" +
         "\\u09b2-\\u09b2" +
         "\\u09b6-\\u09b9" +
         "\\u09bd-\\u09c4" +
         "\\u09c7-\\u09c8" +
         "\\u09cb-\\u09cc" +
         "\\u09ce-\\u09ce" +
         "\\u09d7-\\u09d7" +
         "\\u09dc-\\u09dd" +
         "\\u09df-\\u09e3" +
         "\\u09e6-\\u09f1" +
         "\\u0a01-\\u0a03" +
         "\\u0a05-\\u0a0a" +
         "\\u0a0f-\\u0a10" +
         "\\u0a13-\\u0a28" +
         "\\u0a2a-\\u0a30" +
         "\\u0a32-\\u0a33" +
         "\\u0a35-\\u0a36" +
         "\\u0a38-\\u0a39" +
         "\\u0a3e-\\u0a42" +
         "\\u0a47-\\u0a48" +
         "\\u0a4b-\\u0a4c" +
         "\\u0a51-\\u0a51" +
         "\\u0a59-\\u0a5c" +
         "\\u0a5e-\\u0a5e" +
         "\\u0a66-\\u0a75" +
         "\\u0a81-\\u0a83" +
         "\\u0a85-\\u0a8d" +
         "\\u0a8f-\\u0a91" +
         "\\u0a93-\\u0aa8" +
         "\\u0aaa-\\u0ab0" +
         "\\u0ab2-\\u0ab3" +
         "\\u0ab5-\\u0ab9" +
         "\\u0abd-\\u0ac5" +
         "\\u0ac7-\\u0ac9" +
         "\\u0acb-\\u0acc" +
         "\\u0ad0-\\u0ad0" +
         "\\u0ae0-\\u0ae3" +
         "\\u0ae6-\\u0aef" +
         "\\u0af9-\\u0af9" +
         "\\u0b01-\\u0b03" +
         "\\u0b05-\\u0b0c" +
         "\\u0b0f-\\u0b10" +
         "\\u0b13-\\u0b28" +
         "\\u0b2a-\\u0b30" +
         "\\u0b32-\\u0b33" +
         "\\u0b35-\\u0b39" +
         "\\u0b3d-\\u0b44" +
         "\\u0b47-\\u0b48" +
         "\\u0b4b-\\u0b4c" +
         "\\u0b56-\\u0b57" +
         "\\u0b5c-\\u0b5d" +
         "\\u0b5f-\\u0b63" +
         "\\u0b66-\\u0b6f" +
         "\\u0b71-\\u0b71" +
         "\\u0b82-\\u0b83" +
         "\\u0b85-\\u0b8a" +
         "\\u0b8e-\\u0b90" +
         "\\u0b92-\\u0b95" +
         "\\u0b99-\\u0b9a" +
         "\\u0b9c-\\u0b9c" +
         "\\u0b9e-\\u0b9f" +
         "\\u0ba3-\\u0ba4" +
         "\\u0ba8-\\u0baa" +
         "\\u0bae-\\u0bb9" +
         "\\u0bbe-\\u0bc2" +
         "\\u0bc6-\\u0bc8" +
         "\\u0bca-\\u0bcc" +
         "\\u0bd0-\\u0bd0" +
         "\\u0bd7-\\u0bd7" +
         "\\u0be6-\\u0bef" +
         "\\u0c00-\\u0c03" +
         "\\u0c05-\\u0c0c" +
         "\\u0c0e-\\u0c10" +
         "\\u0c12-\\u0c28" +
         "\\u0c2a-\\u0c39" +
         "\\u0c3d-\\u0c44" +
         "\\u0c46-\\u0c48" +
         "\\u0c4a-\\u0c4c" +
         "\\u0c55-\\u0c56" +
         "\\u0c58-\\u0c5a" +
         "\\u0c60-\\u0c63" +
         "\\u0c66-\\u0c6f" +
         "\\u0c80-\\u0c83" +
         "\\u0c85-\\u0c8c" +
         "\\u0c8e-\\u0c90" +
         "\\u0c92-\\u0ca8" +
         "\\u0caa-\\u0cb3" +
         "\\u0cb5-\\u0cb9" +
         "\\u0cbd-\\u0cc4" +
         "\\u0cc6-\\u0cc8" +
         "\\u0cca-\\u0ccc" +
         "\\u0cd5-\\u0cd6" +
         "\\u0cde-\\u0cde" +
         "\\u0ce0-\\u0ce3" +
         "\\u0ce6-\\u0cef" +
         "\\u0cf1-\\u0cf2" +
         "\\u0d01-\\u0d03" +
         "\\u0d05-\\u0d0c" +
         "\\u0d0e-\\u0d10" +
         "\\u0d12-\\u0d3a" +
         "\\u0d3d-\\u0d44" +
         "\\u0d46-\\u0d48" +
         "\\u0d4a-\\u0d4c" +
         "\\u0d4e-\\u0d4e" +
         "\\u0d54-\\u0d57" +
         "\\u0d5f-\\u0d63" +
         "\\u0d66-\\u0d6f" +
         "\\u0d7a-\\u0d7f" +
         "\\u0d82-\\u0d83" +
         "\\u0d85-\\u0d96" +
         "\\u0d9a-\\u0db1" +
         "\\u0db3-\\u0dbb" +
         "\\u0dbd-\\u0dbd" +
         "\\u0dc0-\\u0dc6" +
         "\\u0dcf-\\u0dd4" +
         "\\u0dd6-\\u0dd6" +
         "\\u0dd8-\\u0ddf" +
         "\\u0de6-\\u0def" +
         "\\u0df2-\\u0df3" +
         "\\u0e01-\\u0e3a" +
         "\\u0e40-\\u0e46" +
         "\\u0e4d-\\u0e4d" +
         "\\u0e50-\\u0e59" +
         "\\u0e81-\\u0e82" +
         "\\u0e84-\\u0e84" +
         "\\u0e87-\\u0e88" +
         "\\u0e8a-\\u0e8a" +
         "\\u0e8d-\\u0e8d" +
         "\\u0e94-\\u0e97" +
         "\\u0e99-\\u0e9f" +
         "\\u0ea1-\\u0ea3" +
         "\\u0ea5-\\u0ea5" +
         "\\u0ea7-\\u0ea7" +
         "\\u0eaa-\\u0eab" +
         "\\u0ead-\\u0eb9" +
         "\\u0ebb-\\u0ebd" +
         "\\u0ec0-\\u0ec4" +
         "\\u0ec6-\\u0ec6" +
         "\\u0ecd-\\u0ecd" +
         "\\u0ed0-\\u0ed9" +
         "\\u0edc-\\u0edf" +
         "\\u0f00-\\u0f00" +
         "\\u0f20-\\u0f29" +
         "\\u0f40-\\u0f47" +
         "\\u0f49-\\u0f6c" +
         "\\u0f71-\\u0f81" +
         "\\u0f88-\\u0f97" +
         "\\u0f99-\\u0fbc" +
         "\\u1000-\\u1036" +
         "\\u1038-\\u1038" +
         "\\u103b-\\u1049" +
         "\\u1050-\\u1062" +
         "\\u1065-\\u1068" +
         "\\u106e-\\u1086" +
         "\\u108e-\\u108e" +
         "\\u1090-\\u1099" +
         "\\u109c-\\u109d" +
         "\\u10a0-\\u10c5" +
         "\\u10c7-\\u10c7" +
         "\\u10cd-\\u10cd" +
         "\\u10d0-\\u10fa" +
         "\\u10fc-\\u1248" +
         "\\u124a-\\u124d" +
         "\\u1250-\\u1256" +
         "\\u1258-\\u1258" +
         "\\u125a-\\u125d" +
         "\\u1260-\\u1288" +
         "\\u128a-\\u128d" +
         "\\u1290-\\u12b0" +
         "\\u12b2-\\u12b5" +
         "\\u12b8-\\u12be" +
         "\\u12c0-\\u12c0" +
         "\\u12c2-\\u12c5" +
         "\\u12c8-\\u12d6" +
         "\\u12d8-\\u1310" +
         "\\u1312-\\u1315" +
         "\\u1318-\\u135a" +
         "\\u135f-\\u135f" +
         "\\u1380-\\u138f" +
         "\\u13a0-\\u13f5" +
         "\\u13f8-\\u13fd" +
         "\\u1401-\\u166c" +
         "\\u166f-\\u167f" +
         "\\u1681-\\u169a" +
         "\\u16a0-\\u16ea" +
         "\\u16ee-\\u16f8" +
         "\\u1700-\\u170c" +
         "\\u170e-\\u1713" +
         "\\u1720-\\u1733" +
         "\\u1740-\\u1753" +
         "\\u1760-\\u176c" +
         "\\u176e-\\u1770" +
         "\\u1772-\\u1773" +
         "\\u1780-\\u17b3" +
         "\\u17b6-\\u17c8" +
         "\\u17d7-\\u17d7" +
         "\\u17dc-\\u17dc" +
         "\\u17e0-\\u17e9" +
         "\\u1810-\\u1819" +
         "\\u1820-\\u1877" +
         "\\u1880-\\u18aa" +
         "\\u18b0-\\u18f5" +
         "\\u1900-\\u191e" +
         "\\u1920-\\u192b" +
         "\\u1930-\\u1938" +
         "\\u1946-\\u196d" +
         "\\u1970-\\u1974" +
         "\\u1980-\\u19ab" +
         "\\u19b0-\\u19c9" +
         "\\u19d0-\\u19d9" +
         "\\u1a00-\\u1a1b" +
         "\\u1a20-\\u1a5e" +
         "\\u1a61-\\u1a74" +
         "\\u1a80-\\u1a89" +
         "\\u1a90-\\u1a99" +
         "\\u1aa7-\\u1aa7" +
         "\\u1b00-\\u1b33" +
         "\\u1b35-\\u1b43" +
         "\\u1b45-\\u1b4b" +
         "\\u1b50-\\u1b59" +
         "\\u1b80-\\u1ba9" +
         "\\u1bac-\\u1be5" +
         "\\u1be7-\\u1bf1" +
         "\\u1c00-\\u1c35" +
         "\\u1c40-\\u1c49" +
         "\\u1c4d-\\u1c7d" +
         "\\u1c80-\\u1c88" +
         "\\u1ce9-\\u1cec" +
         "\\u1cee-\\u1cf3" +
         "\\u1cf5-\\u1cf6" +
         "\\u1d00-\\u1dbf" +
         "\\u1de7-\\u1df4" +
         "\\u1e00-\\u1f15" +
         "\\u1f18-\\u1f1d" +
         "\\u1f20-\\u1f45" +
         "\\u1f48-\\u1f4d" +
         "\\u1f50-\\u1f57" +
         "\\u1f59-\\u1f59" +
         "\\u1f5b-\\u1f5b" +
         "\\u1f5d-\\u1f5d" +
         "\\u1f5f-\\u1f7d" +
         "\\u1f80-\\u1fb4" +
         "\\u1fb6-\\u1fbc" +
         "\\u1fbe-\\u1fbe" +
         "\\u1fc2-\\u1fc4" +
         "\\u1fc6-\\u1fcc" +
         "\\u1fd0-\\u1fd3" +
         "\\u1fd6-\\u1fdb" +
         "\\u1fe0-\\u1fec" +
         "\\u1ff2-\\u1ff4" +
         "\\u1ff6-\\u1ffc" +
         "\\u2071-\\u2071" +
         "\\u207f-\\u207f" +
         "\\u2090-\\u209c" +
         "\\u2102-\\u2102" +
         "\\u2107-\\u2107" +
         "\\u210a-\\u2113" +
         "\\u2115-\\u2115" +
         "\\u2119-\\u211d" +
         "\\u2124-\\u2124" +
         "\\u2126-\\u2126" +
         "\\u2128-\\u2128" +
         "\\u212a-\\u212d" +
         "\\u212f-\\u2139" +
         "\\u213c-\\u213f" +
         "\\u2145-\\u2149" +
         "\\u214e-\\u214e" +
         "\\u2160-\\u2188" +
         "\\u24b6-\\u24e9" +
         "\\u2c00-\\u2c2e" +
         "\\u2c30-\\u2c5e" +
         "\\u2c60-\\u2ce4" +
         "\\u2ceb-\\u2cee" +
         "\\u2cf2-\\u2cf3" +
         "\\u2d00-\\u2d25" +
         "\\u2d27-\\u2d27" +
         "\\u2d2d-\\u2d2d" +
         "\\u2d30-\\u2d67" +
         "\\u2d6f-\\u2d6f" +
         "\\u2d80-\\u2d96" +
         "\\u2da0-\\u2da6" +
         "\\u2da8-\\u2dae" +
         "\\u2db0-\\u2db6" +
         "\\u2db8-\\u2dbe" +
         "\\u2dc0-\\u2dc6" +
         "\\u2dc8-\\u2dce" +
         "\\u2dd0-\\u2dd6" +
         "\\u2dd8-\\u2dde" +
         "\\u2de0-\\u2dff" +
         "\\u2e2f-\\u2e2f" +
         "\\u3005-\\u3007" +
         "\\u3021-\\u3029" +
         "\\u3031-\\u3035" +
         "\\u3038-\\u303c" +
         "\\u3041-\\u3096" +
         "\\u309d-\\u309f" +
         "\\u30a1-\\u30fa" +
         "\\u30fc-\\u30ff" +
         "\\u3105-\\u312d" +
         "\\u3131-\\u318e" +
         "\\u31a0-\\u31ba" +
         "\\u31f0-\\u31ff" +
         "\\u3400-\\u4db5" +
         "\\u4e00-\\u9fd5" +
         "\\ua000-\\ua48c" +
         "\\ua4d0-\\ua4fd" +
         "\\ua500-\\ua60c" +
         "\\ua610-\\ua62b" +
         "\\ua640-\\ua66e" +
         "\\ua674-\\ua67b" +
         "\\ua67f-\\ua6ef" +
         "\\ua717-\\ua71f" +
         "\\ua722-\\ua788" +
         "\\ua78b-\\ua7ae" +
         "\\ua7b0-\\ua7b7" +
         "\\ua7f7-\\ua801" +
         "\\ua803-\\ua805" +
         "\\ua807-\\ua80a" +
         "\\ua80c-\\ua827" +
         "\\ua840-\\ua873" +
         "\\ua880-\\ua8c3" +
         "\\ua8c5-\\ua8c5" +
         "\\ua8d0-\\ua8d9" +
         "\\ua8f2-\\ua8f7" +
         "\\ua8fb-\\ua8fb" +
         "\\ua8fd-\\ua8fd" +
         "\\ua900-\\ua92a" +
         "\\ua930-\\ua952" +
         "\\ua960-\\ua97c" +
         "\\ua980-\\ua9b2" +
         "\\ua9b4-\\ua9bf" +
         "\\ua9cf-\\ua9d9" +
         "\\ua9e0-\\ua9e4" +
         "\\ua9e6-\\ua9fe" +
         "\\uaa00-\\uaa36" +
         "\\uaa40-\\uaa4d" +
         "\\uaa50-\\uaa59" +
         "\\uaa60-\\uaa76" +
         "\\uaa7a-\\uaa7a" +
         "\\uaa7e-\\uaabe" +
         "\\uaac0-\\uaac0" +
         "\\uaac2-\\uaac2" +
         "\\uaadb-\\uaadd" +
         "\\uaae0-\\uaaef" +
         "\\uaaf2-\\uaaf5" +
         "\\uab01-\\uab06" +
         "\\uab09-\\uab0e" +
         "\\uab11-\\uab16" +
         "\\uab20-\\uab26" +
         "\\uab28-\\uab2e" +
         "\\uab30-\\uab5a" +
         "\\uab5c-\\uab65" +
         "\\uab70-\\uabea" +
         "\\uabf0-\\uabf9" +
         "\\uac00-\\ud7a3" +
         "\\ud7b0-\\ud7c6" +
         "\\ud7cb-\\ud7fb" +
         "\\uf900-\\ufa6d" +
         "\\ufa70-\\ufad9" +
         "\\ufb00-\\ufb06" +
         "\\ufb13-\\ufb17" +
         "\\ufb1d-\\ufb28" +
         "\\ufb2a-\\ufb36" +
         "\\ufb38-\\ufb3c" +
         "\\ufb3e-\\ufb3e" +
         "\\ufb40-\\ufb41" +
         "\\ufb43-\\ufb44" +
         "\\ufb46-\\ufbb1" +
         "\\ufbd3-\\ufd3d" +
         "\\ufd50-\\ufd8f" +
         "\\ufd92-\\ufdc7" +
         "\\ufdf0-\\ufdfb" +
         "\\ufe70-\\ufe74" +
         "\\ufe76-\\ufefc" +
         "\\uff10-\\uff19" +
         "\\uff21-\\uff3a" +
         "\\uff41-\\uff5a" +
         "\\uff66-\\uffbe" +
         "\\uffc2-\\uffc7" +
         "\\uffca-\\uffcf" +
         "\\uffd2-\\uffd7" +
         "\\uffda-\\uffdc"
         // "\\u10000-\\u1000b" +
         // "\\u1000d-\\u10026" +
         // "\\u10028-\\u1003a" +
         // "\\u1003c-\\u1003d" +
         // "\\u1003f-\\u1004d" +
         // "\\u10050-\\u1005d" +
         // "\\u10080-\\u100fa" +
         // "\\u10140-\\u10174" +
         // "\\u10280-\\u1029c" +
         // "\\u102a0-\\u102d0" +
         // "\\u10300-\\u1031f" +
         // "\\u10330-\\u1034a" +
         // "\\u10350-\\u1037a" +
         // "\\u10380-\\u1039d" +
         // "\\u103a0-\\u103c3" +
         // "\\u103c8-\\u103cf" +
         // "\\u103d1-\\u103d5" +
         // "\\u10400-\\u1049d" +
         // "\\u104a0-\\u104a9" +
         // "\\u104b0-\\u104d3" +
         // "\\u104d8-\\u104fb" +
         // "\\u10500-\\u10527" +
         // "\\u10530-\\u10563" +
         // "\\u10600-\\u10736" +
         // "\\u10740-\\u10755" +
         // "\\u10760-\\u10767" +
         // "\\u10800-\\u10805" +
         // "\\u10808-\\u10808" +
         // "\\u1080a-\\u10835" +
         // "\\u10837-\\u10838" +
         // "\\u1083c-\\u1083c" +
         // "\\u1083f-\\u10855" +
         // "\\u10860-\\u10876" +
         // "\\u10880-\\u1089e" +
         // "\\u108e0-\\u108f2" +
         // "\\u108f4-\\u108f5" +
         // "\\u10900-\\u10915" +
         // "\\u10920-\\u10939" +
         // "\\u10980-\\u109b7" +
         // "\\u109be-\\u109bf" +
         // "\\u10a00-\\u10a03" +
         // "\\u10a05-\\u10a06" +
         // "\\u10a0c-\\u10a13" +
         // "\\u10a15-\\u10a17" +
         // "\\u10a19-\\u10a33" +
         // "\\u10a60-\\u10a7c" +
         // "\\u10a80-\\u10a9c" +
         // "\\u10ac0-\\u10ac7" +
         // "\\u10ac9-\\u10ae4" +
         // "\\u10b00-\\u10b35" +
         // "\\u10b40-\\u10b55" +
         // "\\u10b60-\\u10b72" +
         // "\\u10b80-\\u10b91" +
         // "\\u10c00-\\u10c48" +
         // "\\u10c80-\\u10cb2" +
         // "\\u10cc0-\\u10cf2" +
         // "\\u11000-\\u11045" +
         // "\\u11066-\\u1106f" +
         // "\\u11082-\\u110b8" +
         // "\\u110d0-\\u110e8" +
         // "\\u110f0-\\u110f9" +
         // "\\u11100-\\u11132" +
         // "\\u11136-\\u1113f" +
         // "\\u11150-\\u11172" +
         // "\\u11176-\\u11176" +
         // "\\u11180-\\u111bf" +
         // "\\u111c1-\\u111c4" +
         // "\\u111d0-\\u111da" +
         // "\\u111dc-\\u111dc" +
         // "\\u11200-\\u11211" +
         // "\\u11213-\\u11234" +
         // "\\u11237-\\u11237" +
         // "\\u1123e-\\u1123e" +
         // "\\u11280-\\u11286" +
         // "\\u11288-\\u11288" +
         // "\\u1128a-\\u1128d" +
         // "\\u1128f-\\u1129d" +
         // "\\u1129f-\\u112a8" +
         // "\\u112b0-\\u112e8" +
         // "\\u112f0-\\u112f9" +
         // "\\u11300-\\u11303" +
         // "\\u11305-\\u1130c" +
         // "\\u1130f-\\u11310" +
         // "\\u11313-\\u11328" +
         // "\\u1132a-\\u11330" +
         // "\\u11332-\\u11333" +
         // "\\u11335-\\u11339" +
         // "\\u1133d-\\u11344" +
         // "\\u11347-\\u11348" +
         // "\\u1134b-\\u1134c" +
         // "\\u11350-\\u11350" +
         // "\\u11357-\\u11357" +
         // "\\u1135d-\\u11363" +
         // "\\u11400-\\u11441" +
         // "\\u11443-\\u11445" +
         // "\\u11447-\\u1144a" +
         // "\\u11450-\\u11459" +
         // "\\u11480-\\u114c1" +
         // "\\u114c4-\\u114c5" +
         // "\\u114c7-\\u114c7" +
         // "\\u114d0-\\u114d9" +
         // "\\u11580-\\u115b5" +
         // "\\u115b8-\\u115be" +
         // "\\u115d8-\\u115dd" +
         // "\\u11600-\\u1163e" +
         // "\\u11640-\\u11640" +
         // "\\u11644-\\u11644" +
         // "\\u11650-\\u11659" +
         // "\\u11680-\\u116b5" +
         // "\\u116c0-\\u116c9" +
         // "\\u11700-\\u11719" +
         // "\\u1171d-\\u1172a" +
         // "\\u11730-\\u11739" +
         // "\\u118a0-\\u118e9" +
         // "\\u118ff-\\u118ff" +
         // "\\u11ac0-\\u11af8" +
         // "\\u11c00-\\u11c08" +
         // "\\u11c0a-\\u11c36" +
         // "\\u11c38-\\u11c3e" +
         // "\\u11c40-\\u11c40" +
         // "\\u11c50-\\u11c59" +
         // "\\u11c72-\\u11c8f" +
         // "\\u11c92-\\u11ca7" +
         // "\\u11ca9-\\u11cb6" +
         // "\\u12000-\\u12399" +
         // "\\u12400-\\u1246e" +
         // "\\u12480-\\u12543" +
         // "\\u13000-\\u1342e" +
         // "\\u14400-\\u14646" +
         // "\\u16800-\\u16a38" +
         // "\\u16a40-\\u16a5e" +
         // "\\u16a60-\\u16a69" +
         // "\\u16ad0-\\u16aed" +
         // "\\u16b00-\\u16b36" +
         // "\\u16b40-\\u16b43" +
         // "\\u16b50-\\u16b59" +
         // "\\u16b63-\\u16b77" +
         // "\\u16b7d-\\u16b8f" +
         // "\\u16f00-\\u16f44" +
         // "\\u16f50-\\u16f7e" +
         // "\\u16f93-\\u16f9f" +
         // "\\u16fe0-\\u16fe0" +
         // "\\u17000-\\u187ec" +
         // "\\u18800-\\u18af2" +
         // "\\u1b000-\\u1b001" +
         // "\\u1bc00-\\u1bc6a" +
         // "\\u1bc70-\\u1bc7c" +
         // "\\u1bc80-\\u1bc88" +
         // "\\u1bc90-\\u1bc99" +
         // "\\u1bc9e-\\u1bc9e" +
         // "\\u1d400-\\u1d454" +
         // "\\u1d456-\\u1d49c" +
         // "\\u1d49e-\\u1d49f" +
         // "\\u1d4a2-\\u1d4a2" +
         // "\\u1d4a5-\\u1d4a6" +
         // "\\u1d4a9-\\u1d4ac" +
         // "\\u1d4ae-\\u1d4b9" +
         // "\\u1d4bb-\\u1d4bb" +
         // "\\u1d4bd-\\u1d4c3" +
         // "\\u1d4c5-\\u1d505" +
         // "\\u1d507-\\u1d50a" +
         // "\\u1d50d-\\u1d514" +
         // "\\u1d516-\\u1d51c" +
         // "\\u1d51e-\\u1d539" +
         // "\\u1d53b-\\u1d53e" +
         // "\\u1d540-\\u1d544" +
         // "\\u1d546-\\u1d546" +
         // "\\u1d54a-\\u1d550" +
         // "\\u1d552-\\u1d6a5" +
         // "\\u1d6a8-\\u1d6c0" +
         // "\\u1d6c2-\\u1d6da" +
         // "\\u1d6dc-\\u1d6fa" +
         // "\\u1d6fc-\\u1d714" +
         // "\\u1d716-\\u1d734" +
         // "\\u1d736-\\u1d74e" +
         // "\\u1d750-\\u1d76e" +
         // "\\u1d770-\\u1d788" +
         // "\\u1d78a-\\u1d7a8" +
         // "\\u1d7aa-\\u1d7c2" +
         // "\\u1d7c4-\\u1d7cb" +
         // "\\u1d7ce-\\u1d7ff" +
         // "\\u1e000-\\u1e006" +
         // "\\u1e008-\\u1e018" +
         // "\\u1e01b-\\u1e021" +
         // "\\u1e023-\\u1e024" +
         // "\\u1e026-\\u1e02a" +
         // "\\u1e800-\\u1e8c4" +
         // "\\u1e900-\\u1e943" +
         // "\\u1e947-\\u1e947" +
         // "\\u1e950-\\u1e959" +
         // "\\u1ee00-\\u1ee03" +
         // "\\u1ee05-\\u1ee1f" +
         // "\\u1ee21-\\u1ee22" +
         // "\\u1ee24-\\u1ee24" +
         // "\\u1ee27-\\u1ee27" +
         // "\\u1ee29-\\u1ee32" +
         // "\\u1ee34-\\u1ee37" +
         // "\\u1ee39-\\u1ee39" +
         // "\\u1ee3b-\\u1ee3b" +
         // "\\u1ee42-\\u1ee42" +
         // "\\u1ee47-\\u1ee47" +
         // "\\u1ee49-\\u1ee49" +
         // "\\u1ee4b-\\u1ee4b" +
         // "\\u1ee4d-\\u1ee4f" +
         // "\\u1ee51-\\u1ee52" +
         // "\\u1ee54-\\u1ee54" +
         // "\\u1ee57-\\u1ee57" +
         // "\\u1ee59-\\u1ee59" +
         // "\\u1ee5b-\\u1ee5b" +
         // "\\u1ee5d-\\u1ee5d" +
         // "\\u1ee5f-\\u1ee5f" +
         // "\\u1ee61-\\u1ee62" +
         // "\\u1ee64-\\u1ee64" +
         // "\\u1ee67-\\u1ee6a" +
         // "\\u1ee6c-\\u1ee72" +
         // "\\u1ee74-\\u1ee77" +
         // "\\u1ee79-\\u1ee7c" +
         // "\\u1ee7e-\\u1ee7e" +
         // "\\u1ee80-\\u1ee89" +
         // "\\u1ee8b-\\u1ee9b" +
         // "\\u1eea1-\\u1eea3" +
         // "\\u1eea5-\\u1eea9" +
         // "\\u1eeab-\\u1eebb" +
         // "\\u1f130-\\u1f149" +
         // "\\u1f150-\\u1f169" +
         // "\\u1f170-\\u1f189" +
         // "\\u20000-\\u2a6d6" +
         // "\\u2a700-\\u2b734" +
         // "\\u2b740-\\u2b81d" +
         // "\\u2b820-\\u2cea1" +
         // "\\u2f800-\\u2fa1d"
};
// @license-end
